/*
 * Decompiled with CFR 0.152.
 */
package com.example.playerlogger;

import com.example.playerlogger.PlayerLoggerPlugin;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;

public class PlayerActionListener
implements Listener {
    private final PlayerLoggerPlugin plugin;
    private final Plugin griefPrevention;

    public PlayerActionListener(PlayerLoggerPlugin plugin) {
        this.plugin = plugin;
        this.griefPrevention = Bukkit.getPluginManager().getPlugin("GriefPrevention");
        if (this.griefPrevention != null && this.griefPrevention.isEnabled()) {
            plugin.getLogger().info("\u2705 GriefPrevention d\u00e9tect\u00e9, int\u00e9gration activ\u00e9e.");
        } else {
            plugin.getLogger().info("\u2139\ufe0f GriefPrevention non d\u00e9tect\u00e9, mode normal.");
        }
    }

    private boolean isInForeignClaim(Player player, Location loc) {
        if (this.griefPrevention == null || !this.griefPrevention.isEnabled()) {
            return false;
        }
        try {
            Class<?> gpClass = Class.forName("me.ryanhamshire.GriefPrevention.GriefPrevention");
            Object gpInstance = gpClass.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
            Object dataStore = gpClass.getField("dataStore").get(gpInstance);
            Object claim = dataStore.getClass().getMethod("getClaimAt", Location.class, Boolean.TYPE, Object.class).invoke(dataStore, loc, false, null);
            if (claim == null) {
                return false;
            }
            String ownerName = (String)claim.getClass().getMethod("getOwnerName", new Class[0]).invoke(claim, new Object[0]);
            return !ownerName.equalsIgnoreCase(player.getName());
        }
        catch (Exception e) {
            return false;
        }
    }

    private void handleAction(Player player, String action, Block block) {
        Location loc = block.getLocation();
        String message = player.getName() + " a " + action + " " + String.valueOf(block.getType()) + " \u00e0 " + loc.getBlockX() + ", " + loc.getBlockY() + ", " + loc.getBlockZ();
        if (this.isInForeignClaim(player, loc)) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "\u26a0 Vous interagissez dans un claim qui ne vous appartient pas !");
            this.plugin.logAction(message + " [DANS UN CLAIM \u00c9TRANGER]");
        } else {
            this.plugin.logAction(message);
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        this.handleAction(event.getPlayer(), "cass\u00e9", event.getBlock());
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        this.handleAction(event.getPlayer(), "plac\u00e9", event.getBlockPlaced());
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent event) {
        if (event.getClickedBlock() != null) {
            this.handleAction(event.getPlayer(), "interagi avec", event.getClickedBlock());
        }
    }
}

