/*
 * Decompiled with CFR 0.152.
 */
package com.example.playerlogger;

import com.example.playerlogger.PlayerLoggerPlugin;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;

public class PlayerActionListener
implements Listener {
    private final PlayerLoggerPlugin plugin;
    private final Plugin griefPrevention;
    private final Plugin worldGuard;
    private final Map<String, Long> lastActionTimes = new HashMap<String, Long>();

    public PlayerActionListener(PlayerLoggerPlugin plugin) {
        this.plugin = plugin;
        this.griefPrevention = Bukkit.getPluginManager().getPlugin("GriefPrevention");
        this.worldGuard = Bukkit.getPluginManager().getPlugin("WorldGuard");
        if (this.griefPrevention != null && this.griefPrevention.isEnabled()) {
            plugin.getLogger().info("\u2705 GriefPrevention d\u00e9tect\u00e9.");
        }
        if (this.worldGuard != null && this.worldGuard.isEnabled()) {
            plugin.getLogger().info("\u2705 WorldGuard d\u00e9tect\u00e9.");
        }
    }

    private boolean isInForeignClaim(Player player, Location loc) {
        return this.isInForeignGPClaim(player, loc) || this.isInForeignWGRegion(player, loc);
    }

    private boolean isInForeignGPClaim(Player player, Location loc) {
        if (this.griefPrevention == null || !this.griefPrevention.isEnabled()) {
            return false;
        }
        try {
            Class<?> gpClass = Class.forName("me.ryanhamshire.GriefPrevention.GriefPrevention");
            Object gpInstance = gpClass.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
            Object dataStore = gpClass.getField("dataStore").get(gpInstance);
            Object claim = dataStore.getClass().getMethod("getClaimAt", Location.class, Boolean.TYPE, Object.class).invoke(dataStore, loc, false, null);
            if (claim == null) {
                return false;
            }
            String ownerName = (String)claim.getClass().getMethod("getOwnerName", new Class[0]).invoke(claim, new Object[0]);
            return !ownerName.equalsIgnoreCase(player.getName());
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isInForeignWGRegion(Player player, Location loc) {
        if (this.worldGuard == null || !this.worldGuard.isEnabled()) {
            return false;
        }
        try {
            Class<?> wgClass = Class.forName("com.sk89q.worldguard.bukkit.WorldGuardPlugin");
            Method inst = wgClass.getMethod("inst", new Class[0]);
            Object wg = inst.invoke(null, new Object[0]);
            Class<?> bukkitAdapter = Class.forName("com.sk89q.worldedit.bukkit.BukkitAdapter");
            Object weWorld = bukkitAdapter.getMethod("adapt", World.class).invoke(null, loc.getWorld());
            Object regionContainer = wg.getClass().getMethod("getRegionContainer", new Class[0]).invoke(wg, new Object[0]);
            Object regionManager = regionContainer.getClass().getMethod("get", Class.forName("com.sk89q.worldedit.world.World")).invoke(regionContainer, weWorld);
            if (regionManager == null) {
                return false;
            }
            Object weLoc = bukkitAdapter.getMethod("adapt", Location.class).invoke(null, loc);
            Collection regions = (Collection)regionManager.getClass().getMethod("getApplicableRegionsIDs", weLoc.getClass()).invoke(regionManager, weLoc);
            if (regions.isEmpty()) {
                return false;
            }
            for (Object regionId : regions) {
                Object region = regionManager.getClass().getMethod("getRegion", String.class).invoke(regionManager, regionId.toString());
                Object owners = region.getClass().getMethod("getOwners", new Class[0]).invoke(region, new Object[0]);
                Collection names = (Collection)owners.getClass().getMethod("getPlayers", new Class[0]).invoke(owners, new Object[0]);
                if (!names.contains(player.getName())) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void handleAction(Player player, String action, String cible, Location loc) {
        String key = player.getName() + "|" + action + "|" + cible + "|" + loc.getBlockX() + "," + loc.getBlockY() + "," + loc.getBlockZ();
        long now = System.currentTimeMillis();
        Long last = this.lastActionTimes.get(key);
        if (last != null && now - last < 1000L) {
            return;
        }
        this.lastActionTimes.put(key, now);
        String message = player.getName() + " a " + action + " " + cible + " \u00e0 " + loc.getBlockX() + ", " + loc.getBlockY() + ", " + loc.getBlockZ();
        if (this.isInForeignClaim(player, loc)) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "\u26a0 Vous interagissez dans une zone qui ne vous appartient pas !");
            this.plugin.logAction(message + " [ZONE PROT\u00c9G\u00c9E]");
        } else {
            this.plugin.logAction(message);
        }
    }

    private boolean isInteractiveBlock(String type) {
        return type.contains("CHEST") || type.contains("DOOR") || type.contains("BUTTON") || type.contains("LEVER") || type.contains("TRAPDOOR") || type.contains("FURNACE") || type.contains("CRAFTING_TABLE") || type.contains("BARREL") || type.contains("SHULKER_BOX") || type.contains("DISPENSER") || type.contains("DROPPER") || type.contains("HOPPER") || type.contains("JUKEBOX");
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        this.handleAction(event.getPlayer(), "cass\u00e9", event.getBlock().getType().toString(), event.getBlock().getLocation());
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        this.handleAction(event.getPlayer(), "plac\u00e9", event.getBlockPlaced().getType().toString(), event.getBlockPlaced().getLocation());
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent event) {
        if (event.getClickedBlock() == null) {
            return;
        }
        switch (event.getAction()) {
            case LEFT_CLICK_BLOCK: {
                break;
            }
            case RIGHT_CLICK_BLOCK: {
                String type = event.getClickedBlock().getType().toString();
                if (!this.isInteractiveBlock(type)) {
                    return;
                }
                this.handleAction(event.getPlayer(), "interagi avec", type, event.getClickedBlock().getLocation());
                break;
            }
        }
    }

    @EventHandler
    public void onProjectileLaunch(ProjectileLaunchEvent event) {
        ProjectileSource projectileSource = event.getEntity().getShooter();
        if (projectileSource instanceof Player) {
            Player player = (Player)projectileSource;
            String projectile = event.getEntityType().toString();
            this.handleAction(player, "lanc\u00e9", projectile, player.getLocation());
        }
    }

    @EventHandler
    public void onEntityKill(EntityDamageByEntityEvent event) {
        Entity entity = event.getDamager();
        if (entity instanceof Player) {
            LivingEntity target;
            Player player = (Player)entity;
            entity = event.getEntity();
            if (entity instanceof LivingEntity && (target = (LivingEntity)entity).getHealth() - event.getFinalDamage() <= 0.0) {
                this.handleAction(player, "tu\u00e9", target.getType().toString(), target.getLocation());
            }
        }
    }
}

