/*
 * Decompiled with CFR 0.152.
 */
package com.example.playerlogger;

import com.example.playerlogger.PlayerActionListener;
import com.example.playerlogger.commands.PlayerLogCommand;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class PlayerLoggerPlugin
extends JavaPlugin {
    private File logFile;

    public void onEnable() {
        this.getLogger().info("\u2705 PlayerActivityLogger activ\u00e9 !");
        this.createLogFile();
        Bukkit.getPluginManager().registerEvents((Listener)new PlayerActionListener(this), (Plugin)this);
        this.getCommand("playerlog").setExecutor((CommandExecutor)new PlayerLogCommand(this));
    }

    public void onDisable() {
        this.getLogger().info("\ud83d\uded1 PlayerActivityLogger d\u00e9sactiv\u00e9.");
    }

    private void createLogFile() {
        File logDir = new File(this.getDataFolder(), "logs");
        if (!logDir.exists()) {
            logDir.mkdirs();
        }
        this.logFile = new File(logDir, "player-activity.log");
        if (!this.logFile.exists()) {
            try {
                this.logFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void logAction(String message) {
        String timestamp = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        String logLine = "[" + timestamp + "] " + message;
        this.getLogger().info(logLine);
        try (FileWriter writer = new FileWriter(this.logFile, true);){
            writer.write(logLine + System.lineSeparator());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

