/*
 * Decompiled with CFR 0.152.
 */
package com.example.playerlogger.commands;

import com.example.playerlogger.PlayerLoggerPlugin;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class PlayerLogCommand
implements CommandExecutor {
    private final PlayerLoggerPlugin plugin;
    private final File logFile;

    public PlayerLogCommand(PlayerLoggerPlugin plugin) {
        this.plugin = plugin;
        this.logFile = new File(plugin.getDataFolder(), "player_actions.log");
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("playerlogger.admin")) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "\u274c Vous n'avez pas la permission d'utiliser cette commande.");
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Usage:");
            sender.sendMessage(String.valueOf(ChatColor.GRAY) + "/playerlog reload");
            sender.sendMessage(String.valueOf(ChatColor.GRAY) + "/playerlog last <pseudo>");
            sender.sendMessage(String.valueOf(ChatColor.GRAY) + "/playerlog <pseudo>");
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "reload": {
                this.plugin.reloadConfig();
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "\u2705 PlayerActivityLogger recharg\u00e9 !");
                break;
            }
            case "last": {
                if (args.length < 2) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /playerlog last <pseudo>");
                    return true;
                }
                String playerName = args[1];
                List<String> lastLines = this.getPlayerActions(playerName, 2);
                if (lastLines.isEmpty()) {
                    sender.sendMessage(String.valueOf(ChatColor.GRAY) + "Aucune action trouv\u00e9e pour " + playerName);
                    break;
                }
                sender.sendMessage(String.valueOf(ChatColor.GOLD) + "\ud83d\udcdc Derni\u00e8res actions de " + playerName + " :");
                lastLines.forEach(line -> sender.sendMessage(String.valueOf(ChatColor.GRAY) + " - " + line));
                break;
            }
            default: {
                String playerName = args[0];
                List<String> allLines = this.getPlayerActions(playerName, -1);
                if (allLines.isEmpty()) {
                    sender.sendMessage(String.valueOf(ChatColor.GRAY) + "Aucune action trouv\u00e9e pour " + playerName);
                    return true;
                }
                try {
                    File playerFile = new File(this.plugin.getDataFolder(), "logs/" + playerName + ".txt");
                    playerFile.getParentFile().mkdirs();
                    Files.write(playerFile.toPath(), allLines, new OpenOption[0]);
                    String link = "plugins/PlayerActivityLogger/logs/" + playerName + ".txt";
                    sender.sendMessage(String.valueOf(ChatColor.GREEN) + "\u2705 Fichier g\u00e9n\u00e9r\u00e9 : " + String.valueOf(ChatColor.AQUA) + link);
                    if (!(sender instanceof Player)) break;
                    Player p = (Player)sender;
                    p.sendMessage(String.valueOf(ChatColor.YELLOW) + "\ud83d\udcc2 Consultez le fichier dans le dossier du serveur.");
                    break;
                }
                catch (IOException e) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "\u274c Erreur lors de la g\u00e9n\u00e9ration du fichier !");
                    e.printStackTrace();
                }
            }
        }
        return true;
    }

    private List<String> getPlayerActions(String playerName, int limit) {
        if (!this.logFile.exists()) {
            return Collections.emptyList();
        }
        try {
            List<String> lines = Files.readAllLines(this.logFile.toPath());
            List<String> filtered = lines.stream().filter(l -> l.toLowerCase().startsWith(playerName.toLowerCase() + " ")).collect(Collectors.toList());
            if (limit > 0 && filtered.size() > limit) {
                return filtered.subList(filtered.size() - limit, filtered.size());
            }
            return filtered;
        }
        catch (IOException e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }
}

